/**
 * \file: svg_typedef.h
 *
 * Contains definition of the SVG types
 *
 * \component: svg_common
 *
 * \author: C. Spetzler
 *
 * \copyright: (c) 2003 - 2011 ADIT Corporation
 *
 * This Software is under a dual license (MIT/GPL).
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 */
#ifndef SVG_TYPEDEF_H
#define SVG_TYPEDEF_H

#ifdef __cplusplus
extern "C" {
#endif

#include "adit_typedef.h"

/*
* Define svg types
*/

#define SVG_TRUE                 1
#define SVG_FALSE                0

typedef char                     SVGChar;
typedef U8                       SVGUint8;
typedef S8                       SVGInt8;
typedef U16                      SVGUint16;
typedef S16                      SVGInt16;
typedef U32                      SVGUint32;
typedef S32                      SVGInt32;
typedef U64                      SVGUint64;
typedef S64                      SVGInt64;
typedef U8                       SVGBoolean;
typedef F32                      SVGFloat;
typedef F64                      SVGDouble;

typedef struct svg_point {
	SVGFloat            x;             /* Pixels position x  */
	SVGFloat            y;             /* Pixels position y  */
} SVGPoint;

/*SVGRect is intentionally just integer based because it should be used as clip rectangle*/
typedef struct svg_rect {
	SVGUint16            x;             /* Clipping position x  */
	SVGUint16            y;             /* Clipping position y  */
	SVGUint16            width;         /* Clipping size width  */
	SVGUint16            height;        /* Clipping size height */
} SVGRect;

/*
* Define the trace module number here (used along with component ID in the class).
*/
typedef enum {
	TR_SVG_COMMON = 0x00,
	TR_SVG_FONT,
	TR_SVG_BITMAP_DECODER,
	/*Maximum value for all graphic trace components */
	TR_MAX_VALUE = 0xFF
} TR_NUM_DEFINE;

#define DISABLE_UNREFERENCED_FOR_LINT(value) (value = value)

#ifdef __cplusplus
}
#endif

#endif /*SVG_TYPEDEF_H */

